import React, { useEffect, useState } from 'react';
import { LayoutDashboard, FileText, Settings, Play, Square, Activity, Database } from 'lucide-react';

export function Sidebar({ state, logs, onStart, onStop, onClearLogs, isProcessing }) {
    // Auto-scroll logs
    const logRef = React.useRef(null);

    useEffect(() => {
        if (logRef.current) {
            logRef.current.scrollTop = logRef.current.scrollHeight;
        }
    }, [logs]);

    return (
        <div className="sidebar">
            <div className="p-4 border-b border-[var(--border-color)]">
                <h1 className="text-xl font-bold bg-gradient-to-r from-blue-400 to-purple-500 bg-clip-text text-transparent" style={{ backgroundClip: 'text', WebkitBackgroundClip: 'text', color: 'var(--accent-primary)' }}>
                    ContentGen Pro
                </h1>
                <p className="text-xs text-[var(--text-muted)] mt-1">Full Stack v1.0</p>
            </div>

            <div className="p-4 flex-1 overflow-y-auto">
                {/* Status Card */}
                <div className="bg-[var(--bg-tertiary)] rounded-lg p-4 mb-4 border border-[var(--border-color)]">
                    <div className="flex justify-between items-center mb-2">
                        <span className="text-xs font-bold text-[var(--text-secondary)] uppercase">Status</span>
                        <Activity size={14} className={isProcessing ? "spin" : ""} color={isProcessing ? "var(--accent-primary)" : "var(--text-muted)"} />
                    </div>
                    <div className="flex justify-between items-end mb-2">
                        <span className="text-sm font-medium">{isProcessing ? 'Processing' : 'Idle'}</span>
                        <span className="text-lg font-bold text-[var(--accent-primary)]">{state.progress}%</span>
                    </div>
                    <div className="w-full bg-[var(--bg-secondary)] h-2 rounded-full overflow-hidden">
                        <div
                            className="h-full bg-[var(--accent-primary)] transition-all duration-300"
                            style={{ width: `${state.progress}%` }}
                        ></div>
                    </div>
                    <div className="text-xs text-[var(--text-muted)] mt-2 truncate">
                        {state.currentTask || 'Ready to start'}
                    </div>
                </div>

                {/* Controls */}
                <div className="mb-6">
                    {!isProcessing ? (
                        <button onClick={onStart} className="btn btn-primary w-full justify-center">
                            <Play size={16} /> Start Generation
                        </button>
                    ) : (
                        <button onClick={onStop} className="btn btn-danger w-full justify-center">
                            <Square size={16} /> Stop Task
                        </button>
                    )}
                </div>

                {/* Logs */}
                <div className="flex justify-between items-center mb-2">
                    <span className="text-xs font-bold text-[var(--text-secondary)] uppercase">Live Logs</span>
                    <button onClick={onClearLogs} className="text-[10px] text-[var(--text-muted)] hover:text-[var(--text-primary)]">Clear</button>
                </div>
                <div
                    ref={logRef}
                    className="bg-[var(--bg-primary)] rounded-lg p-2 h-64 overflow-y-auto font-mono text-[11px] border border-[var(--border-color)]"
                >
                    {logs.length === 0 && <div className="text-[var(--text-muted)] text-center mt-10">No logs yet...</div>}
                    {logs.map((log, i) => (
                        <div key={i} className="mb-1 border-b border-[var(--border-color)] pb-1 last:border-0">
                            <span className="text-[var(--text-muted)] opacity-70">[{log.timestamp}]</span>
                            <span className={`ml-2 ${log.level === 'error' ? 'text-[var(--accent-error)]' :
                                    log.level === 'success' ? 'text-[var(--accent-success)]' :
                                        log.level === 'warning' ? 'text-[var(--accent-warning)]' :
                                            'text-[var(--text-primary)]'
                                }`}>
                                {log.message}
                            </span>
                        </div>
                    ))}
                </div>

            </div>

            <div className="p-4 border-t border-[var(--border-color)]">
                <div className="flex items-center gap-2 text-xs text-[var(--text-muted)]">
                    <Database size={12} />
                    <span>Local DB connected</span>
                </div>
            </div>
        </div>
    );
}
